import { ServerAPI } from '@scifeon/core';

export class DatasetQueryDemo {

    constructor(private server: ServerAPI) {
    }

    async init() {
        this.test();
    }

    async test() {
        
        let myStep = "ST00015";
        let mySteps = ["ST00013", "ST00015"];
        let mySample = "OM001";
        let mySamples = ["OM001", "OM002"];

        /*
        Returns one entity of class "Sample" in database
        */
        const dataset0 = await this.server.datasetQuery([{
            eClass: "Sample",
            entity: "sample"
        }])

         /*
        Returns all entities of class "Sample" with the field "Name" equal to the mySample string variable
        */
        const dataset1 = await this.server.datasetQuery([{
            eClass: "Sample",
            collection: "samples",
            filters: [{ 
                field: "Name", 
                value: mySample
            }] 
        }]);

        /*
        Returns all entities of class "Sample" with the field "Name" equal to one of the values in the mySamples list variable
        */
        const dataset2 = await this.server.datasetQuery([{ 
            eClass: "Sample",
            collection: "samples", 
            filters: [{ 
                field: "Name", 
                values: mySamples
            }] 
        }]);
        
        /*
        Returns one entity of class "Step" with the field "Name" equal to the myStep string variable and all entities of class "Sample" with the field "OriginID" equal to the "id" value found in the first query (note the $ notation)
        */
        const dataset3 = await this.server.datasetQuery([{
            eClass: "Step",
            entity: "step",
            filters: [{
                field: "Name",
                value: myStep
            }]
        },           
        { 
            eClass: "Sample",
            collection: "samples", 
            filters: [{ 
                field: "OriginID", 
                value: "$step.id"
            }] 
        }]);

        /*
        Returns all entities of class "Step" with the field "Name" equal to one of the values in the mySteps list variable and all samples with the field "OriginID" equal to one of the "id" values found in the first query
        */
        const dataset4 = await this.server.datasetQuery([{
            eClass: "Step",
            collection: "steps",
            filters: [{
                field: "Name",
                values: mySteps
            }]
        },           
        { 
            eClass: "Sample",
            collection: "samples", 
            filters: [{ 
                field: "OriginID", 
                in: "steps.id"
            }] 
        }]);

        /*
        Returns all entities of class "Sample" where the end of the field "Name" is equal to the string "01"
        */
        const dataset5 = await this.server.datasetQuery([{ 
            eClass: "Sample",
            collection: "samples", 
            filters: [{ 
                field: "Name", 
                value: "01", 
                op: "endswith"
            }] 
        }]);
        
        /*
        Returns all entities of class "Sample" with the field "Name" equal to one of the values in the mySteps list variable, then sorts them by the "id" field in a descending order
        */
        const dataset6 = await this.server.datasetQuery([{
            eClass: "Sample", 
            collection: "samples", 
            filters: [{ 
                field: "Name", 
                values: mySamples
            }],
            sortings: [{
                field: "id", 
                direction: "desc" 
            }]
        }]);
    }
}