import { FileContext, FileInfo, PLUGIN_TYPE, scifeonPlugin } from '@scifeon/plugins';

@scifeonPlugin({
    name: "DemoSampleDataLoader",
    description: "Loads demo data from Excel",
    type: PLUGIN_TYPE.DATA_LOADER,
    match: (context: FileContext) => true//context.fileInfos[0].wb.Sheets.ScifeonDemoSamples
})

export class DemoSampleDataLoader {
    context: FileContext;
    entities: any[];

    constructor() {
        this.entities = [];
    }

    init(context: FileContext) {
        this.context = context;
        this.readData();
    }

    readData() {
        
        const sheet = this.context.fileInfos[0].wb.Sheets.ScifeonDemoSamples;
        const limit = sheet["!ref"].split(":")[1].match(/\d+/);

        this.entities.push({
            eClass: "Experiment",
            id: "#expID",
            type: "DemoExperiment"
        })
        
        this.entities.push({
            eClass: "Step",
            id: "#stepID",
            experimentID: "#expID"
        })

        this.entities.push({
            eClass: "ResultSet",
            id: "#rsID",
            originID: "#stepID"
        })
        
        for (let i=3; i<=limit; i++) {
            
            this.entities.push({
                eClass: "Sample",
                id: "#sampleID" + i,
                name: sheet["A"+i].v,
                type: sheet["B"+i].v,
                format: sheet["C"+i].v,
                originID: "stepID",
            })
            
            this.entities.push({
                eClass: "ResultValue",
                id: "#valueID",
                type: sheet["B"+i].v,
                valueText: sheet["D"+i].v,
                resultSetID: "#rsID",
                subjectID: "#sampleID" + i,
                subjectClass: "Sample"
            })
        }
    }

    getResult() {
        return {entities: this.entities}
    }
}