import { route } from '@scifeon/plugins';
import { autoinject } from 'aurelia-framework';
import { ServerAPI } from '@scifeon/core';

@autoinject  
@route({
    route: 'app/demo-page', 
    title: 'Demo Page',
})
export class DemoPage {
    series: any[];
    experiments: any[];
    selectedExperiment: any;
    values: any[];

    constructor(private server: ServerAPI) { }

    async init() {
        await this.fetchExperiments();
    }

    async fetchExperiments() {
        this.experiments = [{name: " "}]

        const dataset = await this.server.datasetQuery([
            { eClass: 'Experiment', collection: "experiments", filters: [{ field: 'Type', value: 'DemoExperiment' }]},
        ])
        this.experiments = this.experiments.concat(dataset.experiments);
    }

    async fetchRS() {

        const dataset = await this.server.datasetQuery([
            { eClass: 'Step', entity: "step", filters: [{ field: "ExperimentID", value: this.selectedExperiment.id }]},
            { eClass: "ResultSet", entity: "rs", filters: [{ field: "OriginID", value: '$step.id'}]},
            { eClass: "ResultValue", collection: "values", filters: [{ field: "ResultSetID", value: '$rs.id'}]}
        ])
        this.values = dataset.values
        this.values.sort(function(a, b){return a.subjectID.match(/\d+/) - b.subjectID.match(/\d+/)})
        this.generateSeries();
    }

    generateSeries() {
        this.series = [];
        
        let i = 1;
        this.series.push({
            name: "Demo Series",
            content: {
                points: this.values.map(v => {
                   return { valueX: i++, valueY: Number(v.valueText)}
                })
            }
        })
    }
}